<?php
/**
 * Rest API
 *
 * @package     AutomatorWP\Webhooks\Rest_API
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register receive data from whatsapp endpoints on the WordPress Rest API
 *
 * @since 1.0.0
 */
function automatorwp_whatsapp_rest_api_init() {

    register_rest_route( 'whatsapp/webhooks', automatorwp_whatsapp_get_webhook_slug(), array(
        'methods' => array( 'GET', 'POST' ),
        'callback' => 'automatorwp_whatsapp_rest_api_cb',
        'permission_callback' => '__return_true',
    ) );

}
add_action( 'rest_api_init', 'automatorwp_whatsapp_rest_api_init');

/**
 * Callback used to handle whatsapp received requests
 *
 * @since 1.0.0
 *
 * @param WP_REST_Request $data
 *
 * @return WP_REST_Response
 */
function automatorwp_whatsapp_rest_api_cb( $data ) {

    // Request response received from WhatsApp
    $params = $data->get_params();
	
    if ( ! isset( $params ) ) {
        return new WP_REST_Response( array( 'success' => false, 'message' => __( 'No parameters received', 'automatorwp-pro' ) ), 400 );
    }
	
    $webhook_verification_id = automatorwp_whatsapp_get_option( 'webhook_verification_id', '' );

	// TO DO: cambiar por el campo pedido
	if ( $_SERVER['REQUEST_METHOD'] === 'GET' ) {
		if ( $params['hub_verify_token'] === $webhook_verification_id ){			
			header('Content-Type: text/plain');
            echo $params['hub_challenge'];
            exit;
		} else {
			return new WP_REST_Response( array( 'success' => false, 'message' => __( 'No valid token', 'automatorwp-pro' ) ), 403 );
		}
		
	}
    
    // Actions when message is received
    if ( $_SERVER['REQUEST_METHOD'] === 'POST' ) {
            do_action( 'automatorwp_whatsapp_message_received', $params );
        
            return new WP_REST_Response( array( 'success' => true ), 200 );
    
	}
    
}